<?php
/**
 * Plugin Name: WarForms© 2025 Kevin R. Ray
 * Description: WarForms core plugin (builder, layouts, entries, diagnostics, Site Health).
 * Version: 2025.1.4
 * Author: Kevin R. Ray
 * Author URI: https://github.com/kevinray-dev
 * Text Domain: warforms-reboot
 * License: Proprietary (see LICENSE.txt)
 */
if (!defined('ABSPATH')) exit;

define('WARFORMS_REBOOT_VERSION', '2025.1.4');
define('WARFORMS_REBOOT_PATH', plugin_dir_path(__FILE__));
define('WARFORMS_REBOOT_URL', plugin_dir_url(__FILE__));

// Step 1: DB constants + helpers (GravityForms-style core groundwork)
if ( ! defined( 'WARFORMS_REBOOT_DB_VERSION' ) ) {
	define( 'WARFORMS_REBOOT_DB_VERSION', 1 );
}

/**
 * Get the fully-qualified entries table name.
 *
 * @return string
 */
function warforms_reboot_entries_table() {
	global $wpdb;
	return $wpdb->prefix . 'warforms_entries';
}

// Step 2: DB layer file (install/upgrade + CRUD helpers live here)
require_once WARFORMS_REBOOT_PATH . 'includes/entries-db.php';

// Step 3: Activation hook (actual table install/migrations come in Step 4)
register_activation_hook( __FILE__, 'warforms_reboot_install' );

// Step 5: Upgrade-on-load (run install/migrations when schema version increases)
add_action( 'plugins_loaded', function () {
	if ( ! defined( 'WARFORMS_REBOOT_DB_VERSION' ) || ! function_exists( 'warforms_reboot_get_schema_version' ) ) {
		return;
	}

	$desired = (int) WARFORMS_REBOOT_DB_VERSION;
	$current = (int) warforms_reboot_get_schema_version();

	if ( $current < $desired && function_exists( 'warforms_reboot_install' ) ) {
		warforms_reboot_install();
	}
}, 5 );

require_once WARFORMS_REBOOT_PATH . 'includes/helpers.php';
require_once WARFORMS_REBOOT_PATH . 'includes/site-health.php';
require_once WARFORMS_REBOOT_PATH . 'includes/cpt.php';

if ( is_admin() ) {
	require_once WARFORMS_REBOOT_PATH . 'includes/admin-entries.php';
}
require_once WARFORMS_REBOOT_PATH . 'includes/admin-builder.php';
require_once WARFORMS_REBOOT_PATH . 'includes/shortcode.php';
require_once WARFORMS_REBOOT_PATH . 'includes/validation.php';
require_once WARFORMS_REBOOT_PATH . 'includes/submission.php';

